const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_detailLOD', {
    SerNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "NA"
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Time: {
      type: DataTypes.TIME,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    NoOfSample: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Min: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Avg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Deviation: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MinTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    MaxTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    AvgTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    TestResult: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    LSL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    USL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Target: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    EndTime: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    StartTime: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    LHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }, 
    RHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    LODValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Lot: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_detailLOD',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_batc__7982B600F6718FE7",
        unique: true,
        fields: [
          { name: "SerNo" },
        ]
      },
    ]
  });
};
